REM INFO: MirrorImage.csc v1.4 (PPX4)
REM Copyright  James Aswell, 2000-2002
REM 
REM DESCRIPTION:
REM MirrorImage will create a reflection of the current image
REM	expanding the paper size as necessary.

BEGIN DIALOG Dialog1 119, 64, "Mirror"
	PUSHBUTTON  63, 25, 40, 14, "Right"
	PUSHBUTTON  15, 25, 40, 14, "Left"
	PUSHBUTTON  38, 8, 40, 14, "Above"
	PUSHBUTTON  39, 43, 40, 14, "Below"
END DIALOG

WITHOBJECT "CorelPhotoPaint.Automation.14"
ON ERROR GOTO ERRORHANDLER

	Choice = Dialog(Dialog1)

	.ObjectMerge TRUE
		.EndObject

	.ObjectCreateFromBackground
	
	WIDE = .GetDocumentWidth()
	HIGH = .GetDocumentHeight()

	HORIZONTAL = 1
	VERTICAL = 1

	XOff = 0
	YOff = 0

	IF Choice = 3 THEN ' HORIZONTAL RIGHT
		HORIZONTAL = 2
		WIDE = 2 * WIDE
	ELSEIF Choice = 4 THEN ' HORIZONTAL LEFT
		XOff = WIDE
		WIDE = 2 * WIDE
	ELSEIF Choice = 5 THEN ' VERTICAL ABOVE
		HIGH = 2 * HIGH
	ELSEIF Choice = 6 THEN ' VERTICAL BELOW
		VERTICAL = 2
		YOff = -HIGH
		HIGH = 2 * HIGH
	ENDIF

	.ImagePapersize WIDE, HIGH, XOff, YOff, 5, 255, 255, 255, 0

	.ObjectDuplicate
		.EndObject

	IF Choice = 3 OR Choice = 4 THEN
		.ObjectFlipHorizontal
			.EndObject
	ELSEIF Choice = 5 OR Choice = 6 THEN
		.ObjectFlipVertical
			.EndObject
	ENDIF

	.ObjectAlign HORIZONTAL, VERTICAL, FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, TRUE
		.EndObject

	.ObjectMerge TRUE
		.EndObject

ERRORHANDLER:
SELECT CASE ERRNUM
	CASE 0
	CASE 603
		RESUME NEXT
	CASE ELSE
		MESSAGE "Unexpected Error:" + STR(ERRNUM)
		RESUME NEXT
END SELECT

END WITHOBJECT
